// CrackMe2 - Demonstracja zabezpieczenia poprzez weryfikacj numeru seryjnego, podejcie 2
// Gwny plik programu - HelloCpp.cpp

#include "stdafx.h"
#include "HelloCpp.h"
#include "KolorDlgs.h"

// Zmienne globalne
HINSTANCE hInst;								
TCHAR szTitle[MAX_LOADSTRING];					
TCHAR szWindowClass[MAX_LOADSTRING];			
COLORREF clrKolorTla;							// Kolor ta (RGB)
COLORREF clrKolorTekstu;						// Kolor tekstu (RGB)
char serialText[11];							// przechowujemy wprowadzony przez uytkownika numer seryjny

// Deklaracje funkcji zawartych w tym pliku
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	SerialDlg(HWND, UINT, WPARAM, LPARAM);
void				UtworzTekstKoloru(char * szMessage, COLORREF aColor);
bool TestSerial();

// punkt wejcia do programu
int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR    lpCmdLine, int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);
	MSG msg;
	HACCEL hAccelTable;

	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_HELLOCPP, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_HELLOCPP));

	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return (int) msg.wParam;
}

// Funkcja MyRegisterClass
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_HELLOCPP));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_HELLOCPP);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

// Inicjalizacja aplikacji
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   clrKolorTekstu = 0;
   clrKolorTla = 0xFFFFFF;
   strcpy_s(serialText, "0000000000");

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

// WndProc - przetwarzanie komunikatw
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	char msgText[40];
	switch (message)
	{
	case WM_CREATE:
		DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_SERIAL), hWnd, SerialDlg);
		if(!TestSerial())
			DestroyWindow(hWnd);
		break;
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Obsuga menu
		switch (wmId)
		{
		case IDM_ABOUT:
			if(TestSerial())	
				DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_KOLOR_TEKSTU1:
			if(TestSerial())	
			{
			   DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_KOLOR_TEKSTU), hWnd, KolorTekstu);
			   InvalidateRect(hWnd, NULL, TRUE);
			}
			break;
		case IDM_KOLOR_TLA1:
			if(TestSerial())	
			{
			   DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_KOLOR_TLA), hWnd, KolorTla);
			   InvalidateRect(hWnd, NULL, TRUE);
			}
			break;
		case IDM__WERSJA1:
			MessageBox(hWnd, "CrackMe2 - Demonstracja zabezpieczenia poprzez weryfikacj numeru seryjnego, podejcie 2", "Wersja CrackMe2 1.0", MB_OK);    
			break;
		case IDM__WYBRANY_KOLOR1:
			UtworzTekstKoloru(msgText, clrKolorTla);
			MessageBox(hWnd, msgText , "Kolor ta", MB_OK);    
			UtworzTekstKoloru(msgText, clrKolorTekstu);
			MessageBox(hWnd, msgText, "Kolor tekstu", MB_OK);    
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		// narysowanie tekstu w oknie
		hdc = BeginPaint(hWnd, &ps);
		
		SetTextColor(hdc, clrKolorTekstu);
		SetBkColor(hdc, clrKolorTla);
		TextOut(hdc, 50, 42, "Zam mnie!", 10);
		
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Obsuga okienka dialogowego O programie
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}

// Pomocnicza funkcja konwertujca kolor RGB na tekst
void UtworzTekstKoloru(char * szMessage, COLORREF aColor)
{
	switch(aColor)
	{
	case 0xFFFFFF:
		strcpy_s(szMessage, 40, "Biay");
		break;
	case 0x0000FF:
		strcpy_s(szMessage, 40, "Czerwony");
		break;
	case 0x808080:
		strcpy_s(szMessage, 40, "Szary");
		break;
	case 0x00FF00:
		strcpy_s(szMessage, 40, "Zielony");
		break;
	case 0x00FFFF:
		strcpy_s(szMessage, 40, "ty");
		break;
	case 0:
		strcpy_s(szMessage, 40, "Czarny");
		break;
	case 0xFF0000:
		strcpy_s(szMessage, 40, "Niebieski");
		break;
	default:
		strcpy_s(szMessage, 40, "Nieznany");
		break;
	}
}

// Obsuga okienka dialogowego zucego do wprowadzenia numeru seryjnego
INT_PTR CALLBACK SerialDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			GetDlgItemText(hDlg, IDC_EDIT_SERIAL, serialText, 11);				
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}

bool TestSerial()
{
	char wzorzec[11];
	wzorzec[0] = '_';
	for(int i = 0; i < 3; i++)
	   wzorzec[i+1] = '0' + i + 1;
	for(int i = 0; i < 3; i++)
	   wzorzec[i+4] = 'c' - i;
	for(int i = 0; i < 3; i++)
	   wzorzec[i+7] = '4' + i;
	wzorzec[10] = 0;
    return strcmp(serialText, wzorzec) == 0;
}
